<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// // TEMPORARY: Database setup route for cPanel hosting
// // Access: https://yourdomain.com/setup-database
// // DELETE THIS ROUTE AFTER SETUP!
Route::get('/config-clear', function () {
   

        // Run migrations
        \Artisan::call('config:clear');
        \Artisan::call('cache:clear');
        \Artisan::call('route:clear');
        dd('done');
    
})->name('config.clear');
Auth::routes();
Route::get('/', function () {
    // dd('gelo');
    return redirect()->route('login');
});


Route::get('/dashboard', 'DashboardController@index')->name('dashboard');


Route::middleware('auth')->group(function () {
    // Route::resource('member', 'MemberController');

    // new route start
    // Route::resource('customer', 'CustomerController');

    Route::get('user_roles', 'CustomerController@user_roles_index')->name('user_roles.index');
    Route::post('get_permission', 'CustomerController@get_permission')->name('get_permission');
    Route::post('assign_role', 'CustomerController@assign_role')->name('assign_role');
    Route::get('users_create', 'CustomerController@users_create')->name('users.create');
    Route::post('register_user', 'CustomerController@register_user')->name('register_user');
    Route::get('change_password', 'CustomerController@change_password')->name('change_password');
    Route::post('update_password', 'CustomerController@update_password')->name('update_password');




    Route::get('bill/create', 'BillController@create')->name('bill.create');
    Route::post('bill/', 'BillController@store')->name('bill.store');
    Route::get('bill/list', 'BillController@list')->name('bill.list');
    Route::get('bill/', 'BillController@index')->name('bill.index');
    Route::get('bill/{id}', 'BillController@show')->name('bill.show');
    Route::get('bill/{id}/edit', 'BillController@edit')->name('bill.edit');
    Route::put('bill/{id}', 'BillController@update')->name('bill.update');
    Route::post('bill/delete', 'BillController@destroy')->name('bill.delete');
    Route::get('bill_report', 'BillController@bill_report_index')->name('bill.report');
    Route::get('bill_report_list', 'BillController@bill_report_list')->name('bill.report_list');
    Route::get('bill/{id}/print', 'BillController@print')->name('bill.print');

    Route::get('voucher/create/{id}', 'VoucherController@create')->name('voucher.create');
    Route::post('voucher/', 'VoucherController@store')->name('voucher.store');
    Route::get('voucher/list', 'VoucherController@list')->name('voucher.list');
    Route::get('voucher/', 'VoucherController@index')->name('voucher.index');
    Route::get('voucher/{id}', 'VoucherController@show')->name('voucher.show');
    Route::get('voucher/{id}/edit', 'VoucherController@edit')->name('voucher.edit');
    Route::put('voucher/{id}', 'VoucherController@update')->name('voucher.update');
    Route::post('voucher/delete', 'VoucherController@destroy')->name('voucher.delete');
    Route::get('voucher_report', 'VoucherController@bill_report_index')->name('voucher.report');
    Route::get('voucher_report_list', 'VoucherController@bill_report_list')->name('voucher.report_list');
    Route::get('voucher/{id}/print', 'VoucherController@print')->name('voucher.print');



    // Route::resource('machine', 'MachineController');
    // new route end

    // old route will be remove
    Route::get('members/create', 'MemberController@create')->name('members.create');
    Route::get('members', 'MemberController@index')->name('members.index');
    Route::get('members/list', 'MemberController@list')->name('members.list');
    Route::post('members/store', 'MemberController@store')->name('members.store');
    Route::post('members/delete', 'MemberController@delete')->name('members.delete');
    Route::get('members/{id}/editmember', 'MemberController@editmember')->name('editmember');


    Route::get('settings/membership_plans', 'MemberController@membership_plans')->name('settings.membership_plans');
    Route::post('settings/plan_info', 'MemberController@plan_info')->name('settings.plan_info');
    Route::post('settings/plan_update', 'MemberController@plan_update')->name('settings.plan_update');
    Route::post('settings/plan_delete', 'MemberController@plan_delete')->name('settings.plan_delete');

    Route::get('voucher/{id}/create', 'VoucherController@create')->name('voucher.create');

    Route::get('attendance/', 'MemberController@create_attendance')->name('attendance.create');
    Route::post('submit_attendance/', 'MemberController@submit_attendance')->name('attendance.submit');
    Route::get('member_report/', 'MemberController@member_report')->name('member_report');
    Route::post('members_details/', 'MemberController@members_details')->name('members_details');
    Route::get('attendance_report/', 'MemberController@attendance_report')->name('attendance_report');
    Route::get('attendamce_list/', 'MemberController@attendamce_list')->name('attendamce_list');
    
    
    












    





    Route::get('members/pending', 'MemberController@pending')->name('members.pending');
    Route::get('members/pending/list', 'MemberController@pending_list')->name('members.pending.list');

    Route::get('members/active', 'MemberController@active')->name('members.active');
    Route::get('members/active/list', 'MemberController@active_list')->name('members.active.list');


    Route::get('members/verified', 'MemberController@verified')->name('members.verified');
    Route::get('members/verified/list', 'MemberController@verified_list')->name('members.verified.list');



    Route::get('members/enable_disable', 'MemberController@enable_disable')->name('members.enable_disable');
    Route::post('members/profile_picture', 'MemberController@profile_picture')->name('members.profile_picture');
    Route::post('member/add_father', 'MemberController@add_father')->name('member.add_father');
    Route::post('member/add_mother', 'MemberController@add_mother')->name('member.add_mother');
    Route::post('member/add_wife', 'MemberController@add_wife')->name('member.add_wife');
    Route::post('member/add_husband', 'MemberController@add_husband')->name('member.add_husband');
    Route::post('member/enable', 'MemberController@enable')->name('member.enable');
    Route::post('member/activate_autorize', 'MemberController@activate_autorize')->name('member.activate_autorize');

    Route::get('members/{id}/addfather', 'MemberController@addfather')->name('addfather');
    Route::get('members/{id}/addmother', 'MemberController@addmother')->name('addmother');
    Route::get('members/{id}/addwife', 'MemberController@addwife')->name('addwife');
    Route::get('members/{id}/addhusband', 'MemberController@addhusband')->name('addhusband');
    Route::put('member/{id}/update', 'MemberController@updated_member')->name('member.update');
    Route::get('member/find', 'MemberController@find_member')->name('member.find');
    Route::post('member/family_details', 'MemberController@family_details')->name('member.family_details');

});

