@extends('layout.master')

@section('title', 'Member Report')

@section('content')

    <section>
        <div class="row">
           
            <div class="col-12">

                <div class="card">
                    <div class="card-header">
                        <h1>Member Report</h1>
                    </div>    
                    <div class="card-content" aria-expanded="true">
                        <div class="card-body">
                            @include('inc.messages')

                            <form id="member_search_form" class="form-inline mb-1 justify-content-center" novalidate="novalidate">

                                <div class="form-group">
                                    <input type="text" name="member_number" class="form-control member_number" placeholder="Member Number*" data-rule-required="true" data-msg-required="Member Number is required">

                                </div>

                                <div class="form-group ml-1">
                                    <button type="submit" name="add" class="btn btn-primary add" value="Search">Search</button>
                                </div>
                                <div class="form-group ml-1">
                                    <button type="submit" name="reset" class="btn btn-default reset" value="Reset">Reset</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div id="member_details">
                    
                    </div>
                </div>
                

            </div>


        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/toggle/bootstrap-switch.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/extensions/toastr.css')}}">
@endsection

@section('js')
    <script src="{{asset('app-assets/vendors/js/forms/toggle/bootstrap-checkbox.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/quagga/quagga.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/custom.js')}}" type="text/javascript"></script>
    <script type="text/javascript">

        $(document).ready(function() {
            

            var check_batch = 0;
            var card_ids = [];
            var card_ids2 = [];
            var misscid = 0;

            $('#member_search_form input.member_number').focus();

            // $('#member_search_form input.member_number').inputmask({
            //     'alias': 'integer',
            //     'allowMinus': false,
            //     'allowPlus': false
            // });
            $('#member_search_form button.reset').click(function(){
                // $("#member_details").html('');
                // $('#member_search_form').reset();
                location.reload();
                // $('#member_search_form button.add').prop('disabled', false);

            });
            
            $('#member_search_form').validate({
                errorClass: 'danger',
                successClass: 'success',
                errorPlacement: function(error, element) {
                    error.addClass('w-100').appendTo(element.parents('form'));
                },
                submitHandler: function(form) {
                    $('#member_search_form button.add').prop('disabled', true);

                    var member_number = $(form).find('input.member_number').val();
                    // if (table.columns('.member_number').data().eq(0).indexOf(parseInt(member_number)) === -1) {
                    //     $('#shipped_status_form input.card_ids2').val(card_ids);

                        $.ajax({
                            url: '{!! route('members_details') !!}',
                            method: 'POST',
                            data: {
                                'member_number': member_number,
                                '_token': '{{ csrf_token() }}'

                            },
                            timeout: 5000,
                            error: function (data) {
                                scan_sound(2);
                                toastr.error('Couldn\'t connect to server, check internet connection and re-enter!', 'Error!', {positionClass: 'toast-top-center', containerId: 'toast-top-center'});
                            },
                            success: function(data) {
                                $('#member_search_form input.member_number').val('').focus();
                                console.log(data);
                                if (data.status == 0) {
                                    // id = data.details.id;

                                    // var index = $.inArray(id, card_ids);

                                    // if (index === -1) {
                                    //     // var rowNo = table.rows().count();
                                    //     // table.row.add([rowNo + 1, data.details.member_number, data.details.card_number, data.details.customer_name, data.details.customer_address, data.details.customer_contact, data.details.card_category, data.details.city, remove_button]).node().id = data.details.id;
                                    //     // table.draw(false);
                                    //     // table.order([0, 'desc']).draw();
                                    //     // scan_sound(1);
                                    //     // card_ids.push(data.details.id);
                                    //     // card_ids2=card_ids;
                                    //     // check_batch=data.batch_id;

                                    //     $('#member_search_form button.add').prop('disabled', false);

                                    //     $('#printing_of_cards_form button.confirm').prop('disabled', false);

                                    //     toastr.success(data.success, 'Success!', {positionClass: 'toast-bottom-center', containerId: 'toast-bottom-center'});
                                    // }
                    $("#member_details").html(data.details);
                    scan_sound(1);

                                    
                                        toastr.success(data.success, 'Success!', {positionClass: 'toast-bottom-center', containerId: 'toast-bottom-center'});

                                }
                                else {
                                    scan_sound(2);
                                    toastr.error(data.error, 'Error!', {positionClass: 'toast-top-center', containerId: 'toast-top-center'});
                                }
                            }
                        });
                    // }
                    // else {
                    //     $('#member_search_form button.add').prop('disabled', false);

                    //     toastr.error('Shipment has been added already', 'Error!', {positionClass: 'toast-top-center', containerId: 'toast-top-center'});
                    // }

                    return false;
                }
            });

            

        });
  
     
        
     
    </script>

@endsection
