@extends('layout.master')

@section('title', 'MemberShip Plans')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                            <h1>MemberShip Plans</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                            <table class="table table-bordered datatable" id="datatable" style="z-index: 3;">
                                <thead>
                                    <tr role="row" class="bg-primary white">
                                        <th class="border-primary border-darken-1">S. No.</th>
                                        <th class="border-primary border-darken-1">Name</th>
                                        <th class="border-primary border-darken-1">Fee</th>
                                        <th class="border-primary border-darken-1">Admission Fee</th>
                                        <th class="border-primary border-darken-1">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $i = 0;
                                    @endphp
                                    @foreach ($membership_plans as $item)
                                        <tr id="{{ $item->id }}">
                                            <td>{{ ++$i }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->fee }}</td>
                                            <td>{{ $item->admission_fee }}</td>
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-sm btn-success dropdown-toggle"
                                                        data-toggle="dropdown" aria-haspopup="true"
                                                        aria-expanded="false">Actions</button>
                                                    <div class="dropdown-menu dropdown-menu-sm">
                                                        <button type="button" class="dropdown-item edit">
                                                            <div class="row no-gutters align-items-center">
                                                                <div class="col-2"><i class="ft-check-square"></i>
                                                                </div>
                                                                <div class="col-9 offset-1">Edit</div>
                                                        </button>
                                                        <button type="button" class="dropdown-item delete">
                                                            <div class="row no-gutters align-items-center">
                                                                <div class="col-2"><i class="ft-check-square"></i>
                                                                </div>
                                                                <div class="col-9 offset-1">Delete</div>
                                                        </button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>


                            <div class="modal fade" id="info_modal" role="dialog" aria-labelledby="info_modal_title"
                                aria-hidden="true">
                                <div class="modal-dialog modal-sm" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title" id="info_modal_title">MemberShip Plan</h4>
                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                        </div>
                                        <div class="modal-body text-center">
                                            <form class="form" method="POST"
                                                action="{{ route('settings.plan_update') }}">
                                                @csrf
                                                <input type="hidden" name="membership_id" id="membership_id">
                                                <div class="form-group">
                                                    <input type="text" class="form-control" name="membership_name"
                                                        id="membership_name" required>
                                                </div>
                                                <div class="form-group">
                                                    <input type="text" class="form-control" name="membership_fee"
                                                        id="membership_fee" required>
                                                </div>
                                                <div class="form-group">
                                                    <input type="text" class="form-control" name="membership_admission_fee"
                                                        id="membership_admission_fee" required>
                                                </div>
                                                <div class="form-group">
                                                    <button type="submit" class="btn btn-primary">
                                                        <i class="la la-check-square-o"></i> Update
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/forms/selects/select2.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/extensions/toastr.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/forms/icheck/icheck.css') }}">
    <style type="text/css">
        table.dataTable {
            font-size: 12px;
        }

        table.dataTable thead tr th {
            padding-left: 0.5em;
            white-space: normal;
            word-wrap: break-word;
        }

        table.dataTable thead tr th:before,
        table.dataTable thead tr th:after {
            height: 20px;
            margin-bottom: -10px;
            bottom: 50% !important;
        }

        table.dataTable tbody tr td {
            padding-left: 0.5em;
            padding-right: 0.5em;
        }

        table.dataTable tbody tr td.select-checkbox:before {
            top: 50%;
            border-color: #64a0d2;
        }

        table.dataTable tbody tr.selected td.select-checkbox:after {
            top: 50%;
            text-shadow: none;
        }

        .btn-group .dropdown-menu .dropdown-item {
            white-space: normal;
        }

        #toast-bottom-center.toast-container {
            text-align: center;
        }

        #toast-bottom-center.toast-container .toast {
            display: table;
            width: auto !important;
            text-align: left;
        }

    </style>
@endsection

@section('js')
    <script src="{{ asset('app-assets/vendors/js/extensions/toastr.min.js') }}" type="text/javascript"></script>

    <script src="{{ asset('app-assets/vendors/js/forms/icheck/icheck.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('app-assets/js/scripts/forms/checkbox-radio.js') }}" type="text/javascript"></script>
    <script src="{{ asset('app-assets/vendors/js/forms/select/select2.full.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js') }}" type="text/javascript">
    </script>

    <script src="{{ asset('app-assets/vendors/js/forms/validation/additional-methods.min.js') }}" type="text/javascript">
    </script>
    <script src="{{ asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js') }}"
        type="text/javascript"></script>
    <script src="{{ asset('js/datatable_buttons.js') }}" type="text/javascript"></script>

    <script type="text/javascript">
        $(document).ready(function() {

            $('#datatable tbody').on('click', 'tr td.select-checkbox', function() {
                var id = parseInt($(this).parent('tr').attr('id'));
                var index = $.inArray(id, selected_rows);
                if (index === -1) {
                    selected_rows.push(id);
                } else {
                    selected_rows.splice(index, 1);
                }

                if (selected_rows.length > 0) {
                    table.button('.activate_members').enable();

                } else {
                    table.button('.activate_members').disable();

                }
                console.log(selected_rows);
            });



            $('#datatable tbody').on('click', 'tr button.edit', function() {
                var id = parseInt($(this).parents('tr').attr('id'));

                console.log('clicked');
                $.ajax({
                        url: '{!! route('settings.plan_info') !!}',
                        method: 'POST',
                        data: {
                            '_token': '{{ csrf_token() }}',
                            'id': id
                        }
                    })
                    .done(function(data) {
                        if (data) {
                            var head = '';
                            var bag_numbers = '';

                            bag_numbers = '<img src="{!! asset("'+data+'") !!}" style="width:250px;"/>';
                            membership_name
                            $('#membership_name').val(data.data.name);
                            $('#membership_fee').val(data.data.fee);
                            $('#membership_admission_fee').val(data.data.admission_fee);

                            $('#membership_id').val(data.data.id);

                            $('#info_modal').modal('show');
                        }
                    });
            });

            $('#datatable tbody').on('click', 'tr button.delete', function() {
                var id = parseInt($(this).parents('tr').attr('id'));
                swal({
                    title: 'Are You Sure?',
                    text: 'Select Yes to Create Outward!',
                    icon: 'warning',
                    buttons: {
                        cancel: {
                            text: 'No',
                            value: null,
                            visible: true,
                            closeModal: true,
                        },
                        confirm: {
                            text: 'Yes',
                            value: true,
                            visible: true,
                            closeModal: true
                        }
                    },
                    closeOnClickOutside: false,
                    closeOnEsc: false,
                    dangerMode: true
                }).then(function(confirm) {
                    if (confirm) {
                        $.ajax({
                                url: '{!! route('settings.plan_delete') !!}',
                                method: 'POST',
                                data: {
                                    '_token': '{{ csrf_token() }}',
                                    'id': id
                                }
                            })
                            .done(function(data) {
                                swal("DELETED!", "Plan Deleted!", "error");
                                window.location.reload();
                            });
                    }
                });

            });




            $('input.icheck').iCheck({
                checkboxClass: 'icheckbox_squaret-red',
                radioClass: 'iradio_square-red'
            });
        });
    </script>

@endsection
