@extends('layout.master')

@section('title', 'Mark Attendance')

@section('content')

    <section>
        <div class="row">

            <div class="col-12">

                <div class="card">
                    <div class="card-header">
                        <h1>Mark Attendance</h1>
                    </div>
                    <div class="card-content" aria-expanded="true">
                        <div class="card-body">
                            @include('inc.messages')

                            <form id="mark_attendance_form" class="form-inline mb-1 justify-content-center" novalidate="novalidate">

                                <div class="form-group">
                                    <input type="text" name="member_number" class="form-control member_number" placeholder="Member Number*" data-rule-required="true" data-msg-required="Member Number is required">

                                </div>

                                <div class="form-group ml-1">
                                    <button type="submit" name="add" class="btn btn-primary add" value="Submit">Submit</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/toggle/bootstrap-switch.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/extensions/toastr.css')}}">
@endsection

@section('js')
    <script src="{{asset('app-assets/vendors/js/forms/toggle/bootstrap-checkbox.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/quagga/quagga.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/custom.js')}}" type="text/javascript"></script>
    <script type="text/javascript">

        $(document).ready(function() {


            var check_batch = 0;
            var card_ids = [];
            var card_ids2 = [];
            var misscid = 0;

            $('#mark_attendance_form input.member_number').focus();

            // $('#mark_attendance_form input.member_number').inputmask({
            //     'alias': 'integer',
            //     'allowMinus': false,
            //     'allowPlus': false
            // });


            $('#mark_attendance_form').validate({
                errorClass: 'danger',
                successClass: 'success',
                errorPlacement: function(error, element) {
                    error.addClass('w-100').appendTo(element.parents('form'));
                },
                submitHandler: function(form) {
                    $('#mark_attendance_form button.add').prop('disabled', true);

                    var member_number = $(form).find('input.member_number').val();
                    // if (table.columns('.member_number').data().eq(0).indexOf(parseInt(member_number)) === -1) {
                    //     $('#shipped_status_form input.card_ids2').val(card_ids);

                        $.ajax({
                            url: '{!! route('attendance.submit') !!}',
                            method: 'POST',
                            data: {
                                'member_number': member_number,
                                '_token': '{{ csrf_token() }}'

                            },
                            timeout: 5000,
                            error: function (data) {
                                $('#mark_attendance_form button.add').prop('disabled', false);
                                scan_sound(2);
                                toastr.error('Couldn\'t connect to server, check internet connection and re-enter!', 'Error!', {positionClass: 'toast-top-center', containerId: 'toast-top-center'});
                            },
                            success: function(data) {
                                $('#mark_attendance_form input.member_number').val('').focus();

                                if (data.status == 0) {
                                    $('#mark_attendance_form button.add').prop('disabled', false);
                                        scan_sound(1);
                                        toastr.success(data.success, 'Success!', {positionClass: 'toast-bottom-center', containerId: 'toast-bottom-center'});

                                }
                                else {
                                    $('#mark_attendance_form button.add').prop('disabled', false);
                                    scan_sound(2);
                                    toastr.error(data.error, 'Error!', {positionClass: 'toast-top-center', containerId: 'toast-top-center'});
                                }
                            }
                        });
                    // }
                    // else {
                    //

                    //     toastr.error('Shipment has been added already', 'Error!', {positionClass: 'toast-top-center', containerId: 'toast-top-center'});
                    // }

                    return false;
                }
            });



        });




    </script>

@endsection
