@extends('layout.master')

@section('title', 'Add New Member')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>Add New Member</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                            <form class="form" method="POST" action="{{route('members.store')}}" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="full_name">Full Name</label>
                                                <input type="text" id="full_name" class="form-control"
                                                    placeholder="Full Name" value="{{old('name')}}" name="full_name" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="full_name">Father Name</label>
                                                        <input type="text" id="father_name" class="form-control"
                                                            placeholder="Guardian Name" value="{{old('father_name')}}" name="father_name" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="member_number">Member #</label>
                                                <input type="text" id="member_number" class="form-control"
                                                    placeholder="Member #" value="{{old('member_number')}}" name="member_number" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="gender">Gender</label>
                                                <select name="gender" id="gender" class="form-control" required>
                                                    @if (old('gender')==0)
                                                    <option value="0" selected>Male</option>
                                                    <option value="1">Female</option>
                                                    @elseif(old('gender')==1)
                                                    <option value="0">Male</option>
                                                    <option value="1" selected>Female</option>
                                                    @else
                                                    <option value="">Select</option>
                                                    <option value="0">Male</option>
                                                    <option value="1">Female</option>
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="dob">Date of Birth</label>
                                                <input type="date" id="dob" class="form-control"
                                                    placeholder="DOB" name="dob"  value="{{old('dob')}}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="cnic">CNIC</label>
                                                <input type="text" id="cnic" class="form-control"
                                                    placeholder="CNIC" name="cnic"  value="{{old('cnic')}}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="phone">Contact Number</label>
                                                <input type="text" id="contact_number"  class="form-control"
                                                    placeholder="Contact Number" name="contact_number" value="{{old('contact_number')}}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="email">E-mail</label>
                                        <input type="email" id="email" class="form-control"
                                            placeholder="E-mail" name="email"  value="{{old('email')}}">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="picture">Picture</label>
                                                <input type="file" id="picture" class="form-control"
                                                    placeholder="Picture" name="picture" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="blood_group">Blood Group</label>
                                                <select name="blood_group" id="blood_group" class="form-control">
                                                    @if (old('blood_group')=='A +ve')
                                                        <option value="A +ve" selected>A +ve</option>
                                                        <option value="A -ve">A -ve</option>
                                                        <option value="B +ve">B +ve</option>
                                                        <option value="B -ve">B -ve</option>
                                                        <option value="AB +ve">AB +ve</option>
                                                        <option value="AB -ve">AB -ve</option>
                                                        <option value="O +ve">O +ve</option>
                                                        <option value="O -ve">O -ve</option>

                                                        @elseif(old('blood_group')=='A -ve')
                                                            <option value="A +ve">A +ve</option>
                                                            <option value="A -ve" selected>A -ve</option>
                                                            <option value="B +ve">B +ve</option>
                                                            <option value="B -ve">B -ve</option>
                                                            <option value="AB +ve">AB +ve</option>
                                                            <option value="AB -ve">AB -ve</option>
                                                            <option value="O +ve">O +ve</option>
                                                            <option value="O -ve">O -ve</option>

                                                        @elseif(old('blood_group')=='B +ve')
                                                            <option value="A +ve">A +ve</option>
                                                            <option value="A -ve">A -ve</option>
                                                            <option value="B +ve" selected>B +ve</option>
                                                            <option value="B -ve">B -ve</option>
                                                            <option value="AB +ve">AB +ve</option>
                                                            <option value="AB -ve">AB -ve</option>
                                                            <option value="O +ve">O +ve</option>
                                                            <option value="O -ve">O -ve</option>
                                                    @elseif(old('blood_group')=='B -ve')
                                                        <option value="A +ve">A +ve</option>
                                                        <option value="A -ve" >A -ve</option>
                                                        <option value="B +ve">B +ve</option>
                                                        <option value="B -ve" selected>B -ve</option>
                                                        <option value="AB +ve">AB +ve</option>
                                                        <option value="AB -ve">AB -ve</option>
                                                        <option value="O +ve">O +ve</option>
                                                        <option value="O -ve">O -ve</option>




                                                        @elseif(old('blood_group')=='AB +ve')
                                                        <option value="A +ve">A +ve</option>
                                                        <option value="A -ve" >A -ve</option>
                                                        <option value="B +ve">B +ve</option>
                                                        <option value="B -ve">B -ve</option>
                                                        <option value="AB +ve" selected>AB +ve</option>
                                                        <option value="AB -ve">AB -ve</option>
                                                        <option value="O +ve">O +ve</option>
                                                        <option value="O -ve">O -ve</option>




                                                        @elseif(old('blood_group')=='AB -ve')
                                                        <option value="A +ve">A +ve</option>
                                                        <option value="A -ve" >A -ve</option>
                                                        <option value="B +ve">B +ve</option>
                                                        <option value="B -ve">B -ve</option>
                                                        <option value="AB +ve">AB +ve</option>
                                                        <option value="AB -ve" selected>AB -ve</option>
                                                        <option value="O +ve">O +ve</option>
                                                        <option value="O -ve">O -ve</option>

                                                        @elseif(old('blood_group')=='O +ve')
                                                        <option value="A +ve">A +ve</option>
                                                        <option value="A -ve" >A -ve</option>
                                                        <option value="B +ve">B +ve</option>
                                                        <option value="B -ve">B -ve</option>
                                                        <option value="AB +ve">AB +ve</option>
                                                        <option value="AB -ve">AB -ve</option>
                                                        <option value="O +ve" selected>O +ve</option>
                                                        <option value="O -ve">O -ve</option>

                                                        @elseif(old('blood_group')=='0 -ve')
                                                        <option value="A +ve">A +ve</option>
                                                        <option value="A -ve" selected>A -ve</option>
                                                        <option value="B +ve">B +ve</option>
                                                        <option value="B -ve">B -ve</option>
                                                        <option value="AB +ve">AB +ve</option>
                                                        <option value="AB -ve">AB -ve</option>
                                                        <option value="O +ve">O +ve</option>
                                                        <option value="O -ve" selected>O -ve</option>

                                                    @else
                                                    <option value="">Select</option>
                                                    <option value="A +ve">A +ve</option>
                                                    <option value="A -ve">A -ve</option>
                                                    <option value="B +ve">B +ve</option>
                                                    <option value="B -ve">B -ve</option>
                                                    <option value="AB +ve">AB +ve</option>
                                                    <option value="AB -ve">AB -ve</option>
                                                    <option value="O +ve">O +ve</option>
                                                    <option value="O -ve">O -ve</option>
                                                @endif

                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="membership_plan_id">Membership Plan</label>
                                                <select name="membership_plan_id" id="membership_plan_id" class="form-control" required>
                                                    <option value="">Select</option>
                                                    @foreach ($membership_plans as $item)
                                                        @if (old('membership_plan_id')== $item->id)
                                                        <option value="{{$item->id}}" selected>{{$item->name}}</option>
                                                        @else
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="address">Address</label>
                                                <input type="text" id="address" class="form-control"
                                                    placeholder="Address" name="address" value="{{old('address')}}" required>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                                <div class="form-actions">

                                    <button type="submit" class="btn btn-primary">
                                        <i class="la la-check-square-o"></i> Save
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/custom.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
@endsection
@section('js')
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>


    <script type="text/javascript">
        $(document).ready(function() {

            $('#cnic').inputmask("99999-9999999-9");
            $('#contact_number').inputmask("9999-9999999");
        });


    </script>

@endsection
