<form action="{{route('member.add_husband')}}" method="post" class="mt-2" id="addHusbandForm" novalidate="novalidate">

    @csrf

<div class="row align-items-center justify-content-center">
    <div class="col-md-12">
        <input type="hidden" name="member_id" value="{{$member_id}}">
        <div class="form-group">
            <label>Select Husband</label>

            <fieldset class="form-group">
                <select class="form-control select2" id="husband_id" name="husband_id" data-rule-required="true" data-msg-required="Select Husband">
                    @foreach($husbands as $husband)
                        <option value="{{$husband->id}}">{{$husband->name}} ({{$husband->member_number}})</option>
                    @endforeach
                </select>
            </fieldset>
        </div>
    </div>
    
    <div class="col-auto">
        <div class="form-group text-right my-1">
            <button type="submit" class="btn btn-primary">Add</button>
        <button type="button" class="btn btn-dark btn-min-width mr-1" data-dismiss="modal">Cancel</button>

        </div>
    </div>
</div>

    


</form>

<script type="text/javascript">
    $(document).ready(function () {
        $('#husband_id').prepend('<option value="" selected="selected"></option>').select2({
                width: '100%',
                placeholder: 'Select Husband*',
                dropdownParent:$('#addHusbandForm')
            });

        var errors = 0;
        
        $( "#addHusbandForm" ).validate({


            errorClass:"danger",
            errorPlacement: function(error, element) {
                error.addClass('w-100').appendTo(element.parents('.form-group'));
            },
            submitHandler: function(form) {
                // $(form).find('button[type=submit]').attr('disabled', 'disabled');

                if(errors === 1){
                    return false;
                }else{
                    

                    swal({
                                    title: 'Are You Sure?',
                                    text: 'Select Yes to Add Husband!',
                                    icon: 'warning',
                                    buttons: {
                                        cancel: {
                                            text: 'No',
                                            value: null,
                                            visible: true,
                                            closeModal: true,
                                        },
                                        confirm: {
                                            text: 'Yes',
                                            value: true,
                                            visible: true,
                                            closeModal: true
                                        }
                                    },
                                    closeOnClickOutside: false,
                                    closeOnEsc: false,
                                    dangerMode: true
                                }).then(function (confirm) {
                                    if (confirm) {
                                       
                                        form.submit();

                                    }
                                });
                    $(form).find('button[type=submit]').attr('disabled', 'disabled');
                   
                }

            }
        });


    });
</script>