<form action="{{route('member.add_father')}}" method="post" class="mt-2" id="addFatherForm" novalidate="novalidate">

    @csrf

<div class="row align-items-center justify-content-center">
    <div class="col-md-12">
        <input type="hidden" name="member_id" value="{{$member_id}}">
        <div class="form-group">
            <label>Select Father</label>

            <fieldset class="form-group">
                <select class="form-control select2" id="father_id" name="father_id" data-rule-required="true" data-msg-required="Select Father">
                    @foreach($fathers as $father)
                        <option value="{{$father->id}}">{{$father->name}} ({{$father->member_number}})</option>
                    @endforeach
                </select>
            </fieldset>
        </div>
    </div>
    
    <div class="col-auto">
        <div class="form-group text-right my-1">
            <button type="submit" class="btn btn-primary">Add</button>
        <button type="button" class="btn btn-dark btn-min-width mr-1" data-dismiss="modal">Cancel</button>

        </div>
    </div>
</div>

    


</form>

<script type="text/javascript">
    $(document).ready(function () {
        $('#father_id').prepend('<option value="" selected="selected"></option>').select2({
                width: '100%',
                placeholder: 'Select Father*',
                dropdownParent:$('#addFatherForm')
            });

        var errors = 0;
        
        $( "#addFatherForm" ).validate({


            errorClass:"danger",
            errorPlacement: function(error, element) {
                error.addClass('w-100').appendTo(element.parents('.form-group'));
            },
            submitHandler: function(form) {
                // $(form).find('button[type=submit]').attr('disabled', 'disabled');

                if(errors === 1){
                    return false;
                }else{
                    

                    swal({
                                    title: 'Are You Sure?',
                                    text: 'Select Yes to Add Father!',
                                    icon: 'warning',
                                    buttons: {
                                        cancel: {
                                            text: 'No',
                                            value: null,
                                            visible: true,
                                            closeModal: true,
                                        },
                                        confirm: {
                                            text: 'Yes',
                                            value: true,
                                            visible: true,
                                            closeModal: true
                                        }
                                    },
                                    closeOnClickOutside: false,
                                    closeOnEsc: false,
                                    dangerMode: true
                                }).then(function (confirm) {
                                    if (confirm) {
                                       
                                        form.submit();

                                    }
                                });
                    $(form).find('button[type=submit]').attr('disabled', 'disabled');
                    // swal({
                    //     title: 'Please Wait!',
                    //     text: 'City is being updated!',
                    //     icon: 'info',
                    //     buttons: false,
                    //     closeOnClickOutside: false,
                    //     closeOnEsc: false
                    // });

                    // form.submit();
                }

            }
        });


    });
</script>