@extends('layout.master')

@section('title', 'Dashboard')

@section('content')

    @include('inc.messages')
    <div class="row">
        @if (Auth::user()->role == 1 || in_array(19, session('permissions')))

        <div class="col-xl-3 col-lg-6 col-12">
            <div class="card pull-up">
              <div class="card-content">
                <div class="card-body">
                  <div class="media d-flex">
                    <div class="media-body text-left">
                      <h3 class="warning"></h3>
                      <h6><a href="{{route('members.create')}}">
                            Add Member
                    </a></h6>
                    </div>
                    <div>
                        <i class="la la-user-plus"></i>
                    </div>
                  </div>
                  <div class="progress progress-sm mt-1 mb-0 box-shadow-2">
                    <div class="progress-bar bg-gradient-x-warning" role="progressbar" style="width: 65%"
                    aria-valuenow="65" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        @endif

        @if (Auth::user()->role == 1 || in_array(8, session('permissions')))

          <div class="col-xl-3 col-lg-6 col-12">
            <div class="card pull-up">
              <div class="card-content">
                <div class="card-body">
                  <div class="media d-flex">
                    <div class="media-body text-left">
                      <h3 class="info"></h3>
                      <h6><a href="{{ route('members.index') }}">All Members</a></h6>
                    </div>
                    <div>
                        <i class="la la-user-plus"></i>
                    </div>
                  </div>
                  <div class="progress progress-sm mt-1 mb-0 box-shadow-2">
                    <div class="progress-bar bg-gradient-x-info" role="progressbar" style="width: 80%"
                    aria-valuenow="80" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        @endif


        @if (Auth::user()->role == 1 || in_array(12, session('permissions')))

          <div class="col-xl-3 col-lg-6 col-12">
            <div class="card pull-up">
              <div class="card-content">
                <div class="card-body">
                  <div class="media d-flex">
                    <div class="media-body text-left">
                      <h3 class="danger"></h3>
                      <h6><a href="{{ route('bill.index') }}">Billing </a></h6>
                    </div>
                    <div>
                        <i class="la la-user-plus"></i>
                    </div>
                  </div>
                  <div class="progress progress-sm mt-1 mb-0 box-shadow-2">
                    <div class="progress-bar bg-gradient-x-danger" role="progressbar" style="width: 85%"
                    aria-valuenow="85" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        @endif

        @if (Auth::user()->role == 1 || in_array(14, session('permissions')))

          <div class="col-xl-3 col-lg-6 col-12">
            <div class="card pull-up">
              <div class="card-content">
                <div class="card-body">
                  <div class="media d-flex">
                    <div class="media-body text-left">
                      <h3 class="info"></h3>
                      <h6><a href="{{ route('voucher.index') }}">All Vouchers</a></h6>
                    </div>
                    <div>
                        <i class="la la-check-square-o"></i>
                    </div>
                  </div>
                  <div class="progress progress-sm mt-1 mb-0 box-shadow-2">
                    <div class="progress-bar bg-gradient-x-info" role="progressbar" style="width: 80%"
                    aria-valuenow="80" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        @endif



        @if (Auth::user()->role == 1 || in_array(17, session('permissions')))

        <div class="col-xl-3 col-lg-6 col-12">
          <div class="card pull-up">
            <div class="card-content">
              <div class="card-body">
                <div class="media d-flex">
                  <div class="media-body text-left">
                    <h3 class="danger"></h3>
                    <h6><a href="{{ route('bill.report') }}">Billing Report</a></h6>
                  </div>
                  <div>
                    <i class="la la-check-square-o"></i>
                  </div>
                </div>
                <div class="progress progress-sm mt-1 mb-0 box-shadow-2">
                  <div class="progress-bar bg-gradient-x-danger" role="progressbar" style="width: 85%"
                  aria-valuenow="85" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
        @endif



      </div>
    <div class="row">

    </div>


@endsection
