@extends('layout.master')

@section('title', 'Bill')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>Bill</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Bill #</label>
                                                <input type="text" id="full_name" class="form-control"
                                                    placeholder="Enter Bill #" value="{{$bill->number}}" name="number" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Bill Date</label>
                                                <input type="date" id="full_name" class="form-control"
                                                    placeholder="Enter Date" value="{{$bill->date}}" name="date" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Lot #</label>
                                                <input type="text" id="full_name" class="form-control"
                                                    placeholder="Enter Lot #" value="{{$bill->inward->lot_number}}" name="lot_number" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">

                                                <label for="date">Date</label>
                                                <input type="text" id="date" class="form-control"
                                                    placeholder="Enter Date" value="{{$bill->inward->date}}" name="inward_date" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Customer</label>
                                                <input type="text" id="date" class="form-control"
                                                    placeholder="Enter Date" value="{{$bill->inward->customer->company_name}}" name="date" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="customer_inward">Customer Inward #</label>
                                                <input type="text" id="customer_inward" class="form-control"
                                                    placeholder="Enter Customer Inward #" value="{{$bill->inward->customer_inward}}" name="customer_inward" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="article">Article</label>
                                                <input type="text" id="article" class="form-control"
                                                    placeholder="Enter Article" value="{{$bill->inward->article}}" name="article" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="color">Color</label>
                                                <input type="text" id="color" class="form-control"
                                                    placeholder="Enter Color" value="{{$bill->inward->color}}" name="color" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="guage">Guage</label>
                                                <input type="text" id="guage" class="form-control"
                                                    placeholder="Enter Guage" value="{{$bill->inward->guage}}" name="guage" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="qty">Inward Quantity</label>
                                                <input type="text" id="qty" class="form-control"
                                                    placeholder="Enter Qty" value="{{$bill->inward->qty}}" name="qty" required readonly>
                                            </div>
                                        </div> <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="qty">Outward Quantity</label>
                                                <input type="text" id="qty" class="form-control"
                                                    placeholder="Enter Qty" value="{{$bill->inward->outward->outward_qty}}" name="qty" required readonly>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                                <div>
                                    <h3 class="text-bold mt-1">Processes</h3>
                                    <table class="table">
                                        <thead>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Machine</th>
                                            <th>Quantity</th>
                                            <th>Rate</th>
                                            <th>Amount</th>
                                        </thead>
                                        <tbody>
                                            @php
                                                $i=0;
                                                $rate=0;
                                            @endphp
                                            @foreach ($bill->processes as $process)
                                                <tr>
                                                    <td>{{++$i}}</td>
                                                    @php
                                                        $inward_process_date=date_create($process->inward_process->date);
                                                    @endphp
                                                    <td>{{date_format($inward_process_date,"d-m-Y")}}</td>
                                                    <td>{{$process->inward_process->machine->name}}</td>
                                                    <td>{{$process->inward_process->quantity}}</td>
                                                    <td>{{$process->rate}}</td>
                                                    <td>{{floatval($process->rate)*floatval($process->inward_process->quantity)}}</td>
                                                </tr>
                                                @php
                                                    $rate+=floatval($process->rate)*floatval($process->inward_process->quantity);
                                                @endphp
                                            @endforeach
                                            <tr>
                                                <td colspan="5"></td>
                                                <td><strong>Total: </strong>{{$rate}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/custom.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
@endsection
@section('js')
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>


    <script type="text/javascript">
        $(document).ready(function() {

            $('#number').inputmask("9999-9999999");
        });


        // $('#customer_id').prepend('<option value="" selected="selected"></option>').select2({
        //         width: '100%',
        //         placeholder: 'Select Customer*',
        //         dropdownParent:$('#add_inward_form')

        //     })

    </script>

@endsection
