@extends('layout.master')

@section('title', 'Bill Report')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>Bill Report</h1>

                        </div>
                        <div class="card-body card-dashboard">
                        <div class="row mb-2 justify-content-center">
                            <div class="col-3">
                                <label for="from_date">From Date:</label>
                                <div class="form-group input-group">

                                    <input type="date" name="from_date" class="form-control bg-primary border-primary white rounded-right" id="from_date" placeholder="Date From" data-value="{{ Carbon\Carbon::now() }}">
                                </div>
                            </div>
                            <div class="col-3">
                                <label for="to_date">To Date:</label>

                                <div class="form-group input-group">

                                    <input type="date" name="to_date" class="form-control bg-primary border-primary white rounded-right" id="to_date" placeholder="Date To" data-value="{{ Carbon\Carbon::now() }}">
                                </div>
                            </div>
                            <div class="col-3">
                                <label for="to_date">Customers</label>

                                <div class="form-group input-group">
                                    <select name="customer_id" id="customer_id" class="form-control">
                                        @foreach ($customers as $item)
                                            <option value="{{$item->id}}">{{$item->company_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-2">
                                <div style="height: 25px;"></div>

                                <button type="button" id="search_filter_btn" class="mr-1 mb-1 btn btn-outline-primary btn-min-width"><i class="la la-search"></i> Search</button>
                            </div>
                        </div>
                            @include('inc.messages')
                            <table class="table table-bordered datatable" id="datatable" style="z-index: 3;">
                                <thead>
                                    <tr role="row" class="bg-primary white">
                                        <th class="border-primary border-darken-1">Lot #</th>
                                        <th class="border-primary border-darken-1">Customer</th>
                                        <th class="border-primary border-darken-1">Bill Date</th>
                                        <th class="border-primary border-darken-1">Bill #</th>
                                        <th class="border-primary border-darken-1">Outward #</th>
                                        <th class="border-primary border-darken-1">Amount</th>
                                    </tr>
                                </thead>
                            </table>

                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/extensions/toastr.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/modal/sweetalert.css')}}">

    <style type="text/css">
        table.dataTable {
            font-size: 12px;
        }

        table.dataTable thead tr th {
            padding-left: 0.5em;
            white-space: normal;
            word-wrap: break-word;
        }

        table.dataTable thead tr th:before,
        table.dataTable thead tr th:after {
            height: 20px;
            margin-bottom: -10px;
            bottom: 50% !important;
        }

        table.dataTable tbody tr td {
            padding-left: 0.5em;
            padding-right: 0.5em;
        }

        table.dataTable tbody tr td.select-checkbox:before {
            top: 50%;
            border-color: #64a0d2;
        }

        table.dataTable tbody tr.selected td.select-checkbox:after {
            top: 50%;
            text-shadow: none;
        }

        .btn-group .dropdown-menu .dropdown-item {
            white-space: normal;
        }

        #toast-bottom-center.toast-container {
            text-align: center;
        }

        #toast-bottom-center.toast-container .toast {
            display: table;
            width: auto !important;
            text-align: left;
        }
    </style>
@endsection

@section('js')
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/icheck/icheck.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/js/scripts/forms/checkbox-radio.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/sweetalert.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>

    <script type="text/javascript">
        $(document).ready(function() {

            $('#customer_id').prepend('<option value="" selected="selected"></option>').select2({
                width: '100%',
                placeholder: 'Select Customer*',
            })


var error = 0;


       var selected_rows = [];

            //table start

               var table =  $('.datatable').DataTable({
                   dom: '<"d-inline-block"l><"pull-right"B>tipr',

                        buttons: [
                            {
                        extend: 'excel',
                        title: 'Bill Report',
                        className: 'btn btn-primary',
                        text: '<i class="la la-file-excel-o"></i> Excel',
                        },{
                        extend: 'pdf',
                        title: 'Bill Report',
                        className: 'btn btn-primary',
                        text: '<i class="la la-file-pdf-o"></i> PDF',
                        },'reset'

                        ],
                    select: {
                    info: false,
                    style: 'multi',
                    selector: 'td.select-checkbox',
                    className: 'selected bg-success bg-lighten-5 success'
                },
                    scrollX: false, scrollY: '500px',
                    lengthMenu: [[50, 100, 500, 1000, -1], [50, 100, 500, 1000, 'All']],
                    pageLength: 50,
                    pagingType: 'full_numbers',
                    processing: true,
                    language: {
                        processing: data_table_loader
                    },
                    serverSide: true,
                    ajax: {
                    url: '{{ route('bill.report_list') }}',
                    data: function (d) {
                        d.search_from = $('#from_date').val();
                        d.search_to = $('#to_date').val();
                        d.customer_id = $('#customer_id').val();

                    }
                },
                   rowId: 'id',
                    order: [[1, 'desc']],
                    columns: [
                        {data: 'lot_number', name: 'inwards.lot_number', class: 'align-middle text-center lot_number'},
                        // {orderable: false, searchable: false, data: 'processes', name: 'inwards.lot_number', class: 'align-middle text-center processes'},
                        {data: 'customer_name', name: 'cust.company_name', class: 'align-middle text-center company_name'},
                        {data: 'date', name: 'bill.date', class: 'align-middle text-center date'},
                        {data: 'number', name: 'bills.number', class: 'align-middle text-center number'},
                        {data: 'outw_number', name: 'outwards.number', class: 'align-middle text-center outw_number'},
                        {data: 'amount', name: 'amount', class: 'align-middle text-center amount'},
                    ],
                   rowCallback: function(row, data, index) {
                       var info = table.page.info();

                    //    $('td:eq(0)', row).html(index + 1 + info.page * info.length);
                    //    console.log(info);
                    //    if ($.inArray(data.id, selected_rows) !== -1) {
                    //         table.row(row).select();
                    //     }
                    //     if(data.status == 0){
                    //      $('tr', row).addClass('select-checkbox disabled');

                    //      $('td:eq(0)', row).addClass('select-checkbox disabled');

                    //    }

                   },
                   initComplete: function() {
                    //    var search = $('<tr role="row" class="bg-primary white search"></tr>').appendTo(this.api().table().header());

                    //    var td = '<td style="padding:5px;" class="border-primary border-darken-1"><fieldset class="form-group m-0 position-relative has-icon-right"></fieldset></td>';
                    //    var input = '<input type="text" class="form-control form-control-sm input-sm primary">';
                    //    var icon = '<div class="form-control-position primary"><i class="la la-search"></i></div>';
                    //   this.api().columns().every(function(column_id) {
                    //        var column = this;
                    //        var header = column.header();
                    //        if ($(header).is('.select') || $(header).is('.serial_number') || $(header).is('.action') || $(header).is('.processes') ) {
                    //            $(td).appendTo($(search));
                    //        }
                    //        else {
                    //            var current = $(input).appendTo($(search)).on('change', function() {
                    //                column.search($(this).val(), false, false, true).draw();
                    //            }).wrap(td).after(icon);

                    //            if (column.search()) {
                    //                current.val(column.search());
                    //            }
                    //        }
                    //    });
                    //    this.api().table().columns.adjust();

                   }
                });



       $('#search_filter_btn').on('click',function () {
               table.draw();
            });
        });




    </script>

@endsection
