@extends('layout.master')

@section('title', 'Edit Bill')

@section('content')

    <section>
        <div class="row">
            <div class="col-12">

                <div class="card">

                    <div class="card-content">
                        <div class="card-header">
                             <h1>Edit Bill</h1>

                        </div>
                        <div class="card-body card-dashboard">
                            @include('inc.messages')
                            <form class="form" method="POST" action="{{route('bill.update',['id' => $bill->id])}}" enctype="multipart/form-data" id="edit_bill_form">
                                @csrf
                                @method('put')
                                <div class="form-body">
                                    <div class="row">
                                        <input type="hidden" value="{{$bill->inward->id}}" name="inward_id">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Bill #</label>
                                                <input type="text" id="full_name" class="form-control"
                                                    placeholder="Enter Bill #" value="{{$bill->number}}" name="number" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Bill Date</label>
                                                <input type="date" id="full_name" class="form-control"
                                                    placeholder="Enter Date" value="{{$bill->date}}" name="date" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Lot #</label>
                                                <input type="text" id="full_name" class="form-control"
                                                    placeholder="Enter Lot #" value="{{$bill->inward->lot_number}}" name="lot_number" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="date">Date</label>
                                                <input type="date" id="date" class="form-control"
                                                    placeholder="Enter Date" value="{{$bill->inward->date}}" name="inward_date" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lot_number">Customer</label>
                                                <input type="text" id="date" class="form-control"
                                                   value="{{$bill->inward->customer->company_name}}" name="customer_id" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="customer_inward">Customer Inward #</label>
                                                <input type="text" id="customer_inward" class="form-control"
                                                    placeholder="Enter Customer Inward #" value="{{$bill->inward->customer_inward}}" name="customer_inward" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="article">Article</label>
                                                <input type="text" id="article" class="form-control"
                                                    placeholder="Enter Article" value="{{$bill->inward->article}}" name="article" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="color">Color</label>
                                                <input type="text" id="color" class="form-control"
                                                    placeholder="Enter Color" value="{{$bill->inward->color}}" name="color" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="guage">Guage</label>
                                                <input type="text" id="guage" class="form-control"
                                                    placeholder="Enter Guage" value="{{$bill->inward->guage}}" name="guage" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="qty">Inward Quantity</label>
                                                <input type="text" id="qty" class="form-control"
                                                    placeholder="Enter Qty" value="{{$bill->inward->qty}}" name="qty" required readonly>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="qty">Outward Quantity</label>
                                                <input type="text" id="qty" class="form-control"
                                                    placeholder="Enter Qty" value="{{$bill->inward->outward->outward_qty}}" name="qty" required readonly>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                                <div class="form-body">
                                    <table class="table">
                                        <thead>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Machine</th>
                                            <th>Quantity</th>
                                            {{-- <th>Outward Quantity</th> --}}
                                            <th>Rate</th>
                                            <th>Amount</th>

                                        </thead>
                                        <tbody>
                                            @php
                                                $i=0;
                                                $total = 0;
                                            @endphp
                                            @foreach ($bill->processes as $process)
                                                <tr>
                                                    <td>
                                                        {{++$i}}
                                                    </td>
                                                    <td>
                                                        <input type="text" readonly value="{{$process->inward_process->date}}" class="form-control">
                                                    </td>
                                                    <td>
                                                        <input type="text" readonly value="{{$process->inward_process->machine->name}}" class="form-control">
                                                    </td>
                                                    <td>
                                                        <input type="text" readonly value="{{$process->inward_process->quantity}}" class="form-control">
                                                    </td>
                                                    {{-- <td>
                                                        <input type="text" readonly value="{{$process->outward_process->outward_quantity}}" class="form-control">
                                                    </td> --}}
                                                    <td>

                                                            <input type="text" name="bill_process[{{$process->inward_process->id}}]" value="{{$process->rate}}" class="form-control bill_qtyy" data-rule-required="true" data-msg-required="Enter Rate" onchange="cacl_sub_total(this)">
                                                    </td>
                                                     <td>
                                                        <input type="text" id="" name="" class="form-control amount" value="{{$process->rate*$process->inward_process->quantity}}" readonly onChange="cacl_total(this)">
                                                    </td>
                                                </tr>
                                                @php
                                                    $total += ($process->rate*$process->inward_process->quantity);
                                                @endphp
                                            @endforeach
                                            <tr>
                                                <td colspan="5"></td>
                                                <td>
                                                    <input class="form-control" type="text" id="total" readonly value="{{$total}}">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="form-actions">

                                    <button type="submit" class="btn btn-primary">
                                        <i class="la la-check-square-o"></i> Save
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/custom.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/icheck/icheck.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/forms/selects/select2.min.css')}}">
@endsection
@section('js')
    <script src="{{asset('app-assets/vendors/js/forms/select/select2.full.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}" type="text/javascript"></script>

    <script src="{{asset('app-assets/vendors/js/forms/validation/additional-methods.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/datatable_buttons.js')}}" type="text/javascript"></script>
    <script src="{{asset('app-assets/vendors/js/extensions/toastr.min.js')}}" type="text/javascript"></script>


    <script type="text/javascript">
    function cacl_total(params) {
        console.log(params);


}

function cacl_sub_total(params) {
    var qty = parseFloat(params.parentElement.previousElementSibling.children[0].value);
    params.parentElement.nextElementSibling.children[0].value=qty*parseFloat(params.value)
    var t =0;
    for (var index = 0; index < document.getElementsByClassName('amount').length; index++) {
            var total = document.getElementsByClassName('amount')[index];
                t+= parseFloat(total.value);
        }
    document.getElementById('total').value = t;
}
        $(document).ready(function() {



            $('#number').inputmask("9999-9999999");
            $('.bill_qtyy').inputmask({
                'alias': 'numeric'
            });

        });
        $('#customer_id').prepend('<option value="" selected="selected"></option>').select2({
                width: '100%',
                placeholder: 'Select Customer*',
                dropdownParent:$('#add_outward_form')

            });

            $( "#add_outward_form" ).validate({
                errorClass:"danger",
                errorPlacement: function(error, element) {
                    error.addClass('w-100').appendTo(element.parents('.form-group'));
                },
                submitHandler: function(form) {
                    if(errors === 1){
                        return false;
                    }else{
                        swal({
                                        title: 'Are You Sure?',
                                        text: 'Select Yes to Create Outward!',
                                        icon: 'warning',
                                        buttons: {
                                            cancel: {
                                                text: 'No',
                                                value: null,
                                                visible: true,
                                                closeModal: true,
                                            },
                                            confirm: {
                                                text: 'Yes',
                                                value: true,
                                                visible: true,
                                                closeModal: true
                                            }
                                        },
                                        closeOnClickOutside: false,
                                        closeOnEsc: false,
                                        dangerMode: true
                                    }).then(function (confirm) {
                                        if (confirm) {
                                            form.submit();
                                        }
                                    });
                        $(form).find('button[type=submit]').attr('disabled', 'disabled');

                    }

                }
            });

    </script>

@endsection
