<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('attendances', function (Blueprint $table) {

            $table->integer('member_id')->index();
            $table->dateTime('auth_date_time');
            $table->date('auth_date');
            $table->time('auth_time');
            $table->string('direction');
            $table->string('device_name');
            $table->string('device_sn');
            $table->string('person_name');
            $table->string('card_no');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attendances');
    }
}
