<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMembersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('full_name');
            $table->string('father_name');
            $table->bigInteger('member_number');
            $table->string('gender');
            $table->string('dob');
            $table->string('cnic');
            $table->string('contact_number');
            $table->string('email');
            $table->string('picture');
            $table->string('blood_group')->nullable();
            $table->string('address');
            $table->integer('membership_plan_id')->index();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('members');
    }
}
