<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class UserPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */


    private $actions = [
        'customer.index' => 1,
        'customer.list' => 1,
        'customer.create' => 2,
        'machine.index' => 3,
        'machine.list' => 3,
        'machine.create' => 4,
        'inward.index' => 8,
        'inward.list' => 8,
        'inward.create' => 19,
        'inward.report' => 14,
        'inward.report_list' => 14,
        'inward.inporcess_report' => 15,
        'inward.inporcess_report_list' => 15,
        'inward.machine_report' => 18,
        'inward.machine_report_list' => 18,
        'outward.index' => 10,
        'outward.list' => 10,
        'outward.create' => 11,
        'outward.report' => 16,
        'outward.report_list' => 16,
        'bill.index' => 12,
        'bill.list' => 12,
        'bill.create' => 13,
        'bill.report' => 17,
        'bill.report_list' => 17,
        'machine.customer_rates' => 5,
        'machine.customer_rates_list' => 5,
        'machine.customer_rates_create' => 6,

    ];


    public function handle($request, Closure $next)
    {
            $action = $request->route()->getName();

            if (Auth::user()->role == 1 || !isset($this->actions[$action]) || in_array($this->actions[$action], session('permissions')) ) {
                return $next($request);
            }
            else {
                return response()->view('access_denied');
            }

    }
}
