<?php

namespace App\Http\Controllers;

use App\Attendance;
use App\Bill;
use App\Member;
use App\MembershipPlan;
use App\Voucher;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yajra\Datatables\Datatables;

class MemberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        return view('member.index');
    }

    public function list() {

        $members = Member::leftjoin('membership_plans as mp','mp.id','=','members.membership_plan_id')
                    ->select('members.id','members.full_name','members.father_name','members.member_number','members.gender','members.dob','members.cnic','members.contact_number','members.email','members.picture','members.blood_group','members.address','mp.name as plan')
                    ->where('members.status', 1);
        $datatable = DataTables::of($members)

            ->editColumn('gender', function ($members) {
                if ($members->gender == 0) {
                    return 'Male';
                } else {
                    return 'Female';
                }
            })->addColumn('action', function ($members) {
            $delete = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-close"></i></div><div class="col-9 offset-1">Delete</div></button>';

            $dropdown = '
                    <div class="btn-group">
                      <button type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</button>
                      <div class="dropdown-menu dropdown-menu-sm">';

            $dropdown .= $delete;

            $dropdown .= '<button type="button" class="dropdown-item edit_member"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Edit</div></button>';

            return $dropdown;

        })->addColumn('profile_pic', function ($members) {
            if ($members->picture != null) {
                return '<button class="btn btn-sm btn-outline-primary align-middle"><i class="ft-user"></i></button>';

            } else {
                return '-';
            }
        })->rawColumns(['profile_pic', 'action']);
        return $datatable->make(true);

    }

    public function create()
    {
        // $member = Member::get()->last();
        // if ($member) {
        //     $member_id = intval(ltrim($member->lot_number, "LOT-")) + 1;
        //     if (strlen(strval(intval(ltrim($member->lot_number, "LOT-")))) == 1) {
        //         $lot_number =  'LOT-0000' . strval($member_id);
        //     } elseif (strlen(strval(intval(ltrim($member->lot_number, "LOT-")))) == 2) {
        //         $lot_number =  'LOT-000' . strval($member_id);
        //     } elseif (strlen(strval(intval(ltrim($member->lot_number, "LOT-")))) == 3) {
        //         $lot_number =  'LOT-00' . strval($member_id);
        //     } elseif (strlen(strval(intval(ltrim($member->lot_number, "LOT-")))) == 4) {
        //         $lot_number =  'LOT-0' . strval($member_id);
        //     } else {
        //         $lot_number =  'LOT-' . strval($member_id);
        //     }
        // } else {
        //     $lot_number = "LOT-00001";
        // }
        $membership_plans = MembershipPlan::where('status',1)->get();
        return view('member.create', compact('membership_plans'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'full_name' => 'required',
            'father_name' => 'required',
            'picture' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'gender' => 'required',
            'cnic' => 'required',
            'contact_number' => 'required',
            'email' => 'required',
            'blood_group' => 'nullable',
            'address' => 'required',
            'member_number' => 'required|unique:members,member_number',
            'dob' => 'required',
            'membership_plan_id' => 'required',

        ]);

        $imageName = time() . '.' . $request->picture->extension();

        $request->picture->move(public_path('members_pictures'), $imageName);
        $request->picture = $imageName;
        $member = Member::create($request->all());
        $member->picture = 'members_pictures/' . $imageName;
        $member->save();

        $amount = MembershipPlan::find($member->membership_plan_id);
        $billing_month = Carbon::today()->format('Y-m');
        $bill = new Bill();
        $bill->member_id = $member->id;
        $bill->amount = $amount->admission_fee;
        $bill->date = $billing_month;
        $bill->status = 1;
        $bill->type = 1;
        $bill->save();
        $voucher = Voucher::get()->last();
        if ($voucher) {
            $voucher_id = intval(ltrim($voucher->number, "VC-")) + 1;
            if (strlen(strval(intval(ltrim($voucher->number, "VC-")))) == 1) {
                $number =  'VC-0000' . strval($voucher_id);
            } elseif (strlen(strval(intval(ltrim($voucher->number, "VC-")))) == 2) {
                $number =  'VC-000' . strval($voucher_id);
            } elseif (strlen(strval(intval(ltrim($voucher->number, "VC-")))) == 3) {
                $number =  'VC-00' . strval($voucher_id);
            } elseif (strlen(strval(intval(ltrim($voucher->number, "VC-")))) == 4) {
                $number =  'VC-0' . strval($voucher_id);
            } else {
                $number =  'VC-' . strval($voucher_id);
            }
        } else {
            $number = "VC-00001";
        }
        $new_voucher = new Voucher();
        $new_voucher->bill_id = $bill->id;
        $new_voucher->amount = $bill->amount;
        $new_voucher->number = $number;
        $new_voucher->date = Carbon::today()->format('Y-m-d');
        $new_voucher->save();
        return view('voucher.print',compact('new_voucher','bill'));
        // $url = url('/bill/'.$bill->id.'/print');

        // echo "<script>window.open('".$url."', '_blank')</script>";
        // return redirect(url('/bill/'.$bill->id.'/print'));
    }
    public function editmember($id)
    {
        $member = Member::find($id);
        $membership_plans = MembershipPlan::where('status',1)->get();

        return view('member.edit', compact('member','membership_plans'));
    }

    public function updated_member(Request $request, $id)
    {
        $member = Member::find($id);
        $member->update($request->all());
        if($request->picture){
            $imageName = time() . '.' . $request->picture->extension();
            $request->picture->move(public_path('members_pictures'), $imageName);
            $request->picture = $imageName;
            $member->picture = 'members_pictures/' . $imageName;
            $member->save();
        }
        return redirect('members')->with('success', 'Member updated successfully');

    }
    public function delete(Request $request)
    {
        $id = $request->id;
        $member = Member::find($id);
        if ($member) {
            $member->status = 0;
            $member->save();

            return response()->json(['status' => 1, 'success' => 'Member Deleted']);
        }
    }

    public function membership_plans()
    {
        $membership_plans = MembershipPlan::where('status',1)->get();
        return view('member.membership_plans',compact('membership_plans'));
    }

    public function plan_info(Request $request)
    {
        $plan = MembershipPlan::find($request->id);
        return response()->json(['status' => 1, 'data' => $plan]);

    }

    public function plan_update(Request $request)
    {
        $plan = MembershipPlan::find($request->membership_id);
        $plan->name= $request->membership_name;
        $plan->fee= $request->membership_fee;
        $plan->admission_fee= $request->membership_admission_fee;
        $plan->save();

        return redirect()->back()->with('success', 'Membership Plan Updated');
    }
    public function plan_delete(Request $request)
    {
        $plan = MembershipPlan::find($request->id);
        $plan->status= 0;
        $plan->save();
        return response()->json(['status' => 1]);

    }


    public function create_attendance()
    {
        return view('member.mark_attendance');

    }

    public function submit_attendance(Request $request){
        $member = Member::where('member_number',$request->member_number)->where('status',1);
        if($member->exists()){
            $member = $member->first();
            $today = Carbon::today()->format('d-m-Y');
            $attendace = Attendance::where('member_id',$member->id)->where('attendance_date',$today);
            if(!$attendace->exists()){
                $attendace = new Attendance();
                $attendace->member_id = $member->id;
                $attendace->attendance_date = $today;
                $attendace->attendance_time = Carbon::now()->format('H:i:s');
                $attendace->save();
                return ['status' => 0, 'success' => 'Attendance Marked Successfully'];
            }else{
                return ['status' => 1, 'error' => 'Attendance Already Marked'];
            }
        } else {
            return ['status' => 1, 'error' => 'No Member Found'];

        }
    }

    public function member_report(){
        return view('member.report');
    }

    public function members_details(Request $request){
        $member = Member::where('member_number',$request->member_number)->where('status',1);
        if($member->exists()){
            $data = [];

            $member = $member->first();
            // $data['bills'] = [];
            $data['bills'] = [];
            $data['member_details'] = $member;
            $details = '<div class="container">';
            $details .= '<div class="row">';
            $details .= '<div class="col-12 mb-2">';
            $details .= '<table class="table table-responsive">';
            $details .= '<thead>';
            $details .= '<tr>';
            $details .= '<th>Member#</th>';
            $details .= '<th>Full Name</th>';
            $details .= '<th>Father Name</th>';
            $details .= '<th>Gender</th>';
            $details .= '<th>DOB</th>';
            $details .= '<th>Cnic</th>';
            $details .= '<th>Contact #</th>';
            $details .= '<th>Email</th>';
            $details .= '<th>Picture</th>';
            $details .= '<th>Membership Plan</th>';
            $details .= '</tr>';
            $details .= '</thead>';
            $details .= '<tbody>';


            $details .= '<tr>';
            $details .= '<td>'.$member->member_number.'</td>';
            $details .= '<td>'.$member->full_name.'</td>';
            $details .= '<td>'.$member->father_name.'</td>';
            $details .= '<td>'.$member->gender.'</td>';
            $details .= '<td>'.$member->dob.'</td>';
            $details .= '<td>'.$member->cnic.'</td>';
            $details .= '<td>'.$member->contact_number.'</td>';
            $details .= '<td>'.$member->email.'</td>';
            $details .= '<td><img src="'.asset($member->picture) .'" style="width:100px;"/></td>';
            $details .= '<td>'.$member->membership_plan->name.'</td>';
            $details .= '</tr>';
            $details .= '</tbody>';
            $details .= '</table>';
            $details .= '</div>';


            $details .= '<div class="col-12">';
            $details .= '<h2>Bill History</h2>';
            $details .= '<table class="table">';
            $details .= '<thead>';
            $details .= '<tr>';
            $details .= '<th>Date</th>';
            $details .= '<th>Amount</th>';
            $details .= '<th>Status</th>';
            $details .= '</tr>';
            $details .= '</thead>';
            $details .= '<tbody>';

            foreach($member->bills as $bill){
                    $details .= '<tr>';
                    $details .= '<td>'.$bill->date.'</td>';
                    $details .= '<td>'.$bill->amount.'</td>';

                    // $b_date['date'] = $bill->date;
                    // $b_date['amount'] = $bill->amount;
                    if($bill->status == 1){
                        $details .= '<td class="text-success">Paid</td>';
                        // $b_date['status'] = 'Paid';
                    }else{
                        $details .= '<td class="text-danger">UnPaid</td>';
                        // $b_date['status'] = 'UnPaid';
                    }
                    // array_push($data['bills'], $b_date);

                    $details .= '</tr>';
                }
            $details .= '</tbody>';
            $details .= '</table>';
            $details .= '</div>';


            // $details .= '<div class="col-6">';
            // $details .= '<h2>Attendance History</h2>';
            // $details .= '<table class="table">';
            // $details .= '<thead>';
            // $details .= '<tr>';
            // $details .= '<th>Date</th>';
            // $details .= '<th>Time</th>';
            // $details .= '</tr>';
            // $details .= '</thead>';
            // $details .= '<tbody>';
            // // $data['attendances'] = [];
            // foreach($member->attendances as $attendance){
            //         $details .= '<tr>';
            //         $details .= '<td>'.$attendance->attendance_date.'</td>';
            //         $details .= '<td>'.$attendance->attendance_time.'</td>';

            //         // $a_date['date'] = $attendance->attendance_date;
            //         // $a_date['time'] = $attendance->attendance_time;

            //         // array_push($data['attendances'], $a_date);

            //         $details .= '</tr>';
            //     }
            // $details .= '</tbody>';
            // $details .= '</table>';
            // $details .= '</div>';
            $details .= '</div>';
            $details .= '</div>';
            $details .= '<br>';
            $details .= '<br>';
            $details .= '<br>';
            return ['status' => 0, 'success' => 'Member Found', 'details' => $details];

        } else {
            return ['status' => 1, 'error' => 'No Member Found'];

        }
    }

    public function attendance_report(){
        return view('member.attendance_report');
    }



    public function attendamce_list() {

        $members = Member::leftjoin('attendances as a','a.member_id','=','members.id')
                    ->select('members.id','members.member_number','a.attendance_date as date','a.attendance_time as time')
                    ->where('members.status', 1);
        $datatable = DataTables::of($members);

        return $datatable->make(true);

    }









































    public function pending()
    {

        $fathers = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->get();

        $mothers = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
        ])->get();

        $wives = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
            'partner_id' => null,
        ])->get();

        $husbands = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->get();
        if (Auth::user()->role == 1 || Auth::user()->role == 4) {

            return view('member.pending', compact('fathers', 'mothers', 'wives', 'husbands'));
        } else {
            return redirect()->back();
        }

    }

    public function addfather($id)
    {
        $fathers = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->where('id', '<>', $id)->get();
        $member_id = $id;
        return view('member.add_father', compact('fathers', 'member_id'));

    }

    public function addhusband($id)
    {
        $husbands = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->where('id', '<>', $id)->get();
        $member_id = $id;
        return view('member.add_husband', compact('husbands', 'member_id'));

    }
    public function addmother($id)
    {
        $mothers = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
        ])->where('id', '<>', $id)->get();
        $member_id = $id;
        return view('member.add_mother', compact('mothers', 'member_id'));

    }
    public function addwife($id)
    {
        $wives = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
        ])->where('id', '<>', $id)->get();
        $member_id = $id;
        return view('member.add_wife', compact('wives', 'member_id'));

    }

    public function add_father(Request $request)
    {

        $member = Member::find($request->member_id);
        $member->father_id = $request->father_id;
        $member->save();
        return redirect()->back()->with('success', 'Father Added successfully');

    }
    public function add_husband(Request $request)
    {

        $member = Member::find($request->member_id);
        $member->partner_id = $request->husband_id;
        $member->save();
        return redirect()->back()->with('success', 'Husband Added successfully');

    }

    public function add_mother(Request $request)
    {
        $member = Member::find($request->member_id);
        $member->mother_id = $request->mother_id;
        $member->save();
        return redirect()->back()->with('success', 'Mother Added successfully');

    }

    public function add_wife(Request $request)
    {
        $member = Member::find($request->member_id);
        $member->partner_id = $request->wife_id;
        $member->save();
        return redirect()->back()->with('success', 'Wife Added successfully');
    }

    public function active()
    {

        $fathers = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->get();

        $mothers = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
        ])->get();

        $wives = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
            'partner_id' => null,
        ])->get();

        $husbands = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->get();

        if (Auth::user()->role == 1) {

            return view('member.active', compact('fathers', 'mothers', 'wives', 'husbands'));
        } else {
            return redirect()->back();
        }
    }

    public function pending_list()
    {

        $members = Member::where('status', 0);
        $datatable = DataTables::of($members)
            ->editColumn('status', function ($members) {
                if ($members->active == 1) {
                    return 'Enable';
                } else {
                    return 'Disable';
                }
            })
            ->editColumn('gender', function ($members) {
                if ($members->gender == 0) {
                    return 'Male';
                } else {
                    return 'Female';
                }
            })
            ->editColumn('maritial_status', function ($members) {
                if ($members->maritial_status == 1) {
                    return 'Unmarried';
                } else {
                    return 'Married';
                }
            })->addColumn('action', function ($members) {
            $enable = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Verify</div></button>';
            $disable = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-edit"></i></div><div class="col-9 offset-1">Disable</div></button>';

            $dropdown = '
                    <div class="btn-group">
                      <button type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</button>
                      <div class="dropdown-menu dropdown-menu-sm">';

            if ($members->active == 0) {
                $dropdown .= $enable;
            }
            if ($members->active == 1) {
                $dropdown .= $disable;
            }
            $dropdown .= '<button type="button" class="dropdown-item edit_member"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Edit</div></button>';

            return $dropdown;

        })->addColumn('profile_pic', function ($members) {
            if ($members->picture != null) {
                return '<button class="btn btn-sm btn-outline-primary align-middle"><i class="ft-user"></i></button>';

            } else {
                return '-';
            }
        })->rawColumns(['profile_pic', 'action']);
        return $datatable->make(true);

    }

    public function active_list()
    {

        $members = Member::where('status', 1);
        $datatable = DataTables::of($members)
            ->editColumn('status', function ($members) {
                if ($members->active == 1) {
                    return 'Enable';
                } else {
                    return 'Disable';
                }
            })
            ->editColumn('gender', function ($members) {
                if ($members->gender == 0) {
                    return 'Male';
                } else {
                    return 'Female';
                }
            })
            ->editColumn('maritial_status', function ($members) {
                if ($members->maritial_status == 1) {
                    return 'Unmarried';
                } else {
                    return 'Married';
                }
            })->addColumn('action', function ($members) {
            // $enable = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Activate</div></button>';
            // $disable = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-edit"></i></div><div class="col-9 offset-1">Disable</div></button>';

            $dropdown = '
                    <div class="btn-group">
                      <button type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</button>
                      <div class="dropdown-menu dropdown-menu-sm">';

            // if ($members->active == 0) {
            //     $dropdown .= $enable;
            // }
            // if ($members->active == 1) {
            //     $dropdown .= $disable;
            // }
            if ($members->father_id == null) {
                $dropdown .= '<button type="button" class="dropdown-item add_father"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-plus-circle"></i></div><div class="col-9 offset-1">Add Father</div></button>';

            }
            if ($members->mother_id == null) {
                $dropdown .= '<button type="button" class="dropdown-item add_mother"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-plus-circle"></i></div><div class="col-9 offset-1">Add Mother</div></button>';

            }
            if ($members->maritial_status == 0) {
                if ($members->partner_id == null) {
                    if ($members->gender == 0) {
                        $dropdown .= '<button type="button" class="dropdown-item add_wife"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-plus-circle"></i></div><div class="col-9 offset-1">Add Wife</div></button>';

                    } else {
                        $dropdown .= '<button type="button" class="dropdown-item add_husband"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-plus-circle"></i></div><div class="col-9 offset-1">Add Husband</div></button>';

                    }

                }
            }
            $dropdown .= '<button type="button" class="dropdown-item edit_member"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Edit</div></button>';

            return $dropdown;

        })->addColumn('profile_pic', function ($members) {
            if ($members->picture != null) {
                return '<button class="btn btn-sm btn-outline-primary align-middle"><i class="ft-user"></i></button>';

            } else {
                return '-';
            }
        })->rawColumns(['profile_pic', 'action']);
        return $datatable->make(true);

    }

    public function enable(Request $request)
    {
        $id = $request->id;
        $member = Member::find($id);
        if ($member) {
            $member->status = 2;
            $member->save();

            return response()->json(['status' => 1, 'success' => 'Member Verified!']);
        }
    }

    public function activate_autorize(Request $request)
    {
        $id = $request->id;
        $member = Member::find($id);
        if ($member) {
            $member->status = 1;
            $member->save();

            return response()->json(['status' => 1, 'success' => 'Member Autorized!']);
        }
    }

    public function profile_picture(Request $request)
    {
        $member = Member::find($request->id);
        return $member->picture;
    }

    public function find_member()
    {

        return view('member.search');
    }

    public function family_details(Request $request)
    {
        $member_details = Member::where('member_number', $request->member_number);

        if ($member_details->exists()) {
            $member_details = $member_details->get()->first();
            if ($member_details->father_id == null) {
                $member_details->father_id = 0;
            }
            if ($member_details->mother_id == null) {
                $member_details->mother_id = 0;
            }

            if ($member_details->status == 0) {
                return ['status' => 1, 'error' => 'Inactive Member'];

            }
            $details = '<div class="row">';

            // if ($request->check_batch != 0) {
            // $gender = $member_details->gender;

            if ($member_details->maritial_status == 0) {
                //married
                if ($member_details->gender == 0) {
                    $details .= '<div class="col-12">
                        <div class="card">
                            <div class="card-header">
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="list-group">
                                                <a class="list-group-item active  text-center">
                                                    Member
                                                </a>
                                                <a href="#" class="list-group-item list-group-item-action disabled">
                                                ' . $member_details->name . '
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="list-group">
                                                <a  class="list-group-item active text-center">
                                                   Wife
                                                </a>';
                    if ($member_details->partner_id != 0 || $member_details->partner_id != null) {
                        $wife = Member::find($member_details->partner_id);
                        if ($wife) {
                            $details .= '<a class="list-group-item list-group-item-action">' . $wife->name . '</a>';

                        }
                    } else {
                        $details .= '<a class="list-group-item list-group-item-action">-</a>';

                    }
                    $details .= '</div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
                } else {
                    $details .= '<div class="col-12">
                        <div class="card">
                            <div class="card-header">
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="list-group">
                                                <a class="list-group-item active  text-center">
                                                    Member
                                                </a>
                                                <a href="#" class="list-group-item list-group-item-action disabled">
                                                ' . $member_details->name . '
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="list-group">
                                                <a  class="list-group-item active text-center">
                                                   Husband
                                                </a>';
                    if ($member_details->partner_id != 0 || $member_details->partner_id != null) {
                        $wife = Member::find($member_details->partner_id);
                        if ($wife) {
                            $details .= '<a class="list-group-item list-group-item-action">' . $wife->name . '</a>';

                        } else {
                            $details .= '<a class="list-group-item list-group-item-action">-</a>';

                        }
                    } else {
                        $details .= '<a class="list-group-item list-group-item-action">-</a>';

                    }
                    $details .= '</div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
                }

            } else {
                //unmarried
                $details .= '<div class="col-12">
                    <div class="card">
                        <div class="card-header">
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="list-group">
                                            <a class="list-group-item active  text-center">
                                                Member
                                            </a>
                                            <a href="#" class="list-group-item list-group-item-action disabled text-center">' . $member_details->name . '</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            }

            $details .= '    <div class="col-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title text-center">Parents</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="list-group">
                                        <a class="list-group-item active  text-center">
                                            Mother
                                        </a>';
            if ($member_details->mother_id != 0 || $member_details->mother_id != null) {
                $mother = Member::find($member_details->mother_id);
                if ($mother) {
                    $details .= '<a class="list-group-item list-group-item-action">' . $mother->name . '</a>';

                } else {
                    $details .= '<a class="list-group-item list-group-item-action">-</a>';

                }
            } else {
                $details .= '<a class="list-group-item list-group-item-action">-</a>';

            }

            $details .= '</div>
                                </div>
                                <div class="col-6">
                                    <div class="list-group">
                                        <a  class="list-group-item active text-center">
                                           Father
                                        </a>';
            if ($member_details->father_id != 0 || $member_details->father_id != null) {
                $father = Member::find($member_details->father_id);
                if ($father) {
                    $details .= '<a class="list-group-item list-group-item-action">' . $father->name . '</a>';

                } else {
                    $details .= '<a class="list-group-item list-group-item-action">-</a>';

                }
            } else {
                $details .= '<a class="list-group-item list-group-item-action">-</a>';

            }
            $details .= '</div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>';

//sibling start
            $details .= '    <div class="col-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title text-center">Siblings</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="list-group">
                                        <a class="list-group-item active  text-center">
                                            Brothers
                                        </a>';

            $brothers = Member::where('father_id', $member_details->father_id)->orWhere('mother_id', $member_details->mother_id);
            if ($brothers->exists()) {
                $brothers = $brothers->get();

                foreach ($brothers as $brother) {
                    if ($brother->gender == 0 && $brother->id != $member_details->id) {

                        $details .= '<a class="list-group-item list-group-item-action">' . $brother->name . '</a>';
                    }

                }
            } else {
                $details .= '<a class="list-group-item list-group-item-action">-</a>';

            }

            $details .= '</div>
                                </div>
                                <div class="col-6">
                                    <div class="list-group">
                                        <a  class="list-group-item active text-center">
                                           Sisters
                                        </a>';
            $sisters = Member::where('father_id', $member_details->father_id)->orWhere('mother_id', $member_details->mother_id);
            if ($sisters->exists()) {
                $sisters = $sisters->get();

                foreach ($sisters as $sister) {
                    if ($sister->gender == 1 && $sister->id != $member_details->id) {

                        $details .= '<a class="list-group-item list-group-item-action">' . $sister->name . '</a>';
                    }

                }
            } else {
                $details .= '<a class="list-group-item list-group-item-action">-</a>';

            }
            $details .= '</div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>';

//sibling end

            if ($member_details->gender == 0) {

                $chidlrens = Member::where('father_id', $member_details->id);

                if ($chidlrens->exists()) {
                    $chidlrens = $chidlrens->get();
                    $details .= '    <div class="col-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title text-center">Childrens</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="list-group">
                                            <a class="list-group-item active  text-center">
                                                Sons
                                            </a>';
                    foreach ($chidlrens as $child) {
                        if ($child->gender == 0) {
                            # code...
                            $details .= '<a href="#" class="list-group-item list-group-item-action">' . $child->name . '</a>';
                        }
                    }
                    $details .= '</div>
                                    </div>
                                    <div class="col-6">
                                        <div class="list-group">
                                            <a  class="list-group-item active text-center">
                                               Daughters
                                            </a>';
                    foreach ($chidlrens as $child) {
                        if ($child->gender == 1) {
                            # code...
                            $details .= '<a href="#" class="list-group-item list-group-item-action">' . $child->name . '</a>';
                        }
                    }
                    $details .= '</div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
                }

            } else {
                $chidlrens = Member::where('mother_id', $member_details->id);
                if ($chidlrens->exists()) {
                    $chidlrens = $chidlrens->get();
                    $details .= '    <div class="col-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title text-center">Childrens</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="list-group">
                                            <a class="list-group-item active  text-center">
                                                Sons
                                            </a>';
                    foreach ($chidlrens as $child) {
                        if ($child->gender == 0) {
                            # code...
                            $details .= '<a href="#" class="list-group-item list-group-item-action">' . $child->name . '</a>';
                        }
                    }
                    $details .= '</div>
                                    </div>
                                    <div class="col-6">
                                        <div class="list-group">
                                            <a  class="list-group-item active text-center">
                                               Daughters
                                            </a>';
                    foreach ($chidlrens as $child) {
                        if ($child->gender == 1) {
                            # code...
                            $details .= '<a href="#" class="list-group-item list-group-item-action">' . $child->name . '</a>';
                        }
                    }
                    $details .= '</div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
                }
            }

            $details .= '</div>';

//                 if($gender == 0){
            // //male
            //                 }else{
            //                     //female
            //                 }

            // BatchDataCard::where('id', $batch_card_data->id)->update(['status' => 2]);
            return ['status' => 0, 'success' => 'Member Found', 'details' => $details];
        } else {
            return ['status' => 1, 'error' => 'No Member Found'];

        }
    }

    public function verified()
    {

        $fathers = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->get();

        $mothers = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
        ])->get();

        $wives = Member::where([
            'status' => 1,
            'gender' => 1,
            'maritial_status' => 0,
            'partner_id' => null,
        ])->get();

        $husbands = Member::where([
            'status' => 1,
            'gender' => 0,
            'maritial_status' => 0,
        ])->get();

        if (Auth::user()->role == 1 || Auth::user()->role == 5) {

            return view('member.verified', compact('fathers', 'mothers', 'wives', 'husbands'));
        } else {
            return redirect()->back();
        }
    }

    public function verified_list()
    {

        $members = Member::where('status', 2);
        $datatable = DataTables::of($members)
            ->editColumn('status', function ($members) {
                if ($members->active == 1) {
                    return 'Enable';
                } else {
                    return 'Disable';
                }
            })
            ->editColumn('gender', function ($members) {
                if ($members->gender == 0) {
                    return 'Male';
                } else {
                    return 'Female';
                }
            })
            ->editColumn('maritial_status', function ($members) {
                if ($members->maritial_status == 1) {
                    return 'Unmarried';
                } else {
                    return 'Married';
                }
            })->addColumn('action', function ($members) {
            $enable = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Authorized</div></button>';
            $disable = '<button type="button" class="dropdown-item status"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-edit"></i></div><div class="col-9 offset-1">Disable</div></button>';

            $dropdown = '
                    <div class="btn-group">
                      <button type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</button>
                      <div class="dropdown-menu dropdown-menu-sm">';

            if ($members->active == 0) {
                $dropdown .= $enable;
            }
            if ($members->active == 1) {
                $dropdown .= $disable;
            }
            $dropdown .= '<button type="button" class="dropdown-item edit_member"><div class="row no-gutters align-items-center"><div class="col-2"><i class="ft-check-square"></i></div><div class="col-9 offset-1">Edit</div></button>';

            return $dropdown;

        })->addColumn('profile_pic', function ($members) {
            if ($members->picture != null) {
                return '<button class="btn btn-sm btn-outline-primary align-middle"><i class="ft-user"></i></button>';

            } else {
                return '-';
            }
        })->rawColumns(['profile_pic', 'action']);
        return $datatable->make(true);

    }
}
